return {
	["notice.label"] = "Notice:",
	["notice.text"] = "These options may not take effect until the next relaunch of the game.",
	["credits.label"] = "The following individuals have contributed to the Morrowind Script Extender:",
	["logWarningsWithLuaStack.label"] = "Log warnings with lua stacktrace?",
	["logWarningsWithLuaStack.description"] = "When enabled, any warnings raised during normal gameplay that would write to warnings.txt will also write to mwse.log. In addition, a stack trace is provided to give context to what mod may be responsible for the warning.\n\nThis can lead to superfluous log entries when using certain mods, like Better Bodies.",
	["runInBackground.label"] = "Run Morrowind in the background?",
	["runInBackground.description"] = "By default Morrowind skips most game logic when not in focus. When using windowed mode (including borderless fullscreen), this feature allows Morrowind to continue running. Enabling this can also help to increase stability, due to how Morrowind handles some audio threads.",
	["playAudioInBackground.label"] = "Play audio in background?",
	["playAudioInBackground.description"] = "By default, Morrowind does not use global audio playback, meaning that audio stops playing when the window is not in focus. Turning this on allows audio to work in the background.",
	["letterboxMovies.label"] = "Letterbox movies?",
	["letterboxMovies.description"] = "Morrowind stretches movies to fill the whole window by default. This option will instead render movies with black bars to either side, centering the movie in the window.",
	["patchNiFlipController.label"] = "Fix NiFlipController cloning?",
	["patchNiFlipController.description"] = "Morrowind incorrectly handles the affected map when cloning NiFlipController objects, preventing mods from using the controller for anything but the base map. MWSE fixes this issue. However, some mods contain bugged assets that have the incorrect affected map assigned, relying on the bug to reassign the controller back to the base map. Disabling this fix will provide support for these mods, but will also prevent newer mods from taking advantage of the fixed controller.\n\nIt is recommended that you leave this enabled unless you know you need the compatibility.",
	["keepAllNetImmerseObjectsAlive.label"] = "Cache all NetImmerse lua objects?",
	["keepAllNetImmerseObjectsAlive.description"] = "WARNING: Only used for debugging purposes. Enabling this without knowing what you're doing WILL lead to memory leaks.\n\nWhen enabled, NetImmerse objects will use the same lua object caching system that TES3 objects use, allowing them to be string-compared or used as table keys.",
	["enableLegacyLuaMods.label"] = "Enable legacy lua mods?",
	["enableLegacyLuaMods.description"] = "If enabled, early alpha lua mods will be supported\n\nLegacy lua mods can be found in:\nData Files\\MWSE\\lua folder.",
	["enableLogColors.label"] = "Enable Log Colors",
	["enableLogColors.description"] = "If enabled, mwseLogger logging messages will be color-coded based on the severity of the message. However, this will make the MWSE.log file more difficult to read in a text editor.",
	["enableLogLineNumbers.label"] = "Enable Log Line Numbers",
	["enableLogLineNumbers.description"] = "If enabled, line numbers will be included in logging messages generated by mwseLoggers. This does come with a slight performance cost, but it is unlikely to be very noticeable. Line numbers are only computed if the logging level is high enough to print the log message.",
	["enableDependencyChecks.label"] = "Enable Dependency Checks",
	["enableDependencyChecks.description"] = "If enabled, MWSE will check for dependencies of mods and warn the user if they are missing.",
	["replaceDialogueFiltering.label"] = "Replace Dialogue Filtering",
	["replaceDialogueFiltering.description"] = "If enabled, MWSE will replace the logic for dialogue filtering. This feature is currently in public testing.",
	["enableLuaErrorNotifications.label"] = "Enable lua error notifications",
	["enableLuaErrorNotifications.description"] = "If enabled, notification pop-ups will appear when a lua error is logged. They contain the mod name and a short error description only. Many released mods cause frequent non-critical errors, so this mode is primarily intended for use in development and bugfixing.",
	["useSkinnedAccurateActivationRaytests.label"] = "Enable skinned-accurate activation raytests",
	["useSkinnedAccurateActivationRaytests.description"] = "If enabled, the player activation target raytest will be more accurate around skinned actors. This may impose a performance penalty in very complex situations.",
	["suppressUselessWarnings.label"] = "Suppress useless game warnings?",
	["suppressUselessWarnings.description"] = "If enabled, the initial startup warning about mismatched masters is suppressed. This warning is almost always displayed on any modded install, and often prompts users to click Yes to All, hiding actually helpful warnings.",
	["replaceLightSorting.label"] = "Replace light sorting?",
	["replaceLightSorting.description"] = "If enabled, the default method of prioritizing lights that affect a mesh is replaced with a new method. This greatly reduces the amount of landscape seams as well as the amount of light popping, but may diminish the impact of carried torches in some environments.",
}
